/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.block;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.MarkerBlock;

public class InternMarkerBlock
extends MarkerBlock {
    static final long serialVersionUID = 107L;
    private int serializedDataVersion = 1;

    public InternMarkerBlock() {
        this.setNumber(1);
    }

    public InternMarkerBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
        if (wiringDiagram instanceof WiringDiagramKop) {
            this.setNumber(((WiringDiagramKop)wiringDiagram).getFreeInternMarkerNumber(1));
        } else {
            this.setNumber(1);
        }
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        return result;
    }

    public String getNumberPrefix() {
        return "IM";
    }

    public boolean calculateBinaryValue() {
        super.calculateBinaryValue();
        return this.fValue;
    }

    public int getNumberType() {
        return -1;
    }

    public String getType() {
        return "LadderDiagram";
    }

    public void initBlockNumber() {
        WiringDiagramKop wd = (WiringDiagramKop)this.getWiringDiagram();
        if (wd != null) {
            this.setNumber(wd.getFreeInternMarkerNumber(1));
        }
    }

    public boolean isNegativ() {
        return false;
    }
}

